#version 330

#if VTF_TRANSFORM
uniform sampler1D transformMap;
#else
uniform mat4 world;
#endif
uniform mat4 view;
uniform mat4 viewproj;

#if UNIFORM_COLOR
uniform vec4 uniformColor;
#endif
#if ANIM
uniform vec4 worldMatrix3x4Array[144];
uniform float numBones;
#endif

in vec4 vertex;
in vec3 normal;
in vec4 uv0; //uv, z: transform index, w: packed texture indices
#if TANGENT
in vec4 tangent;
#endif
#if VERTEX_COLOR
in vec4 colour;
#endif
#if ANIM
in vec4 blendWeights;
in vec4 blendIndices;
#endif

out vec4 pos;
out vec3 norm;
out vec2 uv;
out vec3 idx; //texIdx - dif, nor, asg
#if TANGENT
out vec3 tang;
out vec3 binorm;
#endif
#if VERTEX_COLOR
out vec4 vcolor;
#endif

void main()
{
#if VERTEX_COLOR
	vcolor = colour;
#endif
#if UNIFORM_COLOR
	vcolor = uniformColor;
#endif

#if VTF_TRANSFORM

	int fetchBase = int(3*uv0.z + 0.5);
	int localFetchBase = fetchBase/4096;
	fetchBase -= localFetchBase*4096;
	
	vec4 worldPos;
	vec3 worldNorm;
	
	mat3x4 worldT;
	worldT[0] = texelFetch(transformMap, fetchBase, 0);
	worldT[1] = texelFetch(transformMap, fetchBase + 1, 0);
	worldT[2] = texelFetch(transformMap, fetchBase + 2, 0);
	
	if(localFetchBase > 0) {
		mat3x4 localT;
		localT[0] = texelFetch(transformMap, localFetchBase, 0);
		localT[1] = texelFetch(transformMap, localFetchBase + 1, 0);
		localT[2] = texelFetch(transformMap, localFetchBase + 2, 0);
		
		worldPos = vec4(vec4(vertex * localT, 1.0) * worldT, 1.0);
		worldNorm = (normal * mat3(localT)) * mat3(worldT);
	#if TANGENT
		tang = (tangent.xyz * mat3(localT)) * mat3(worldT);
	#endif //_TANGENT
	}
	else {
		worldPos = vec4(vertex * worldT, 1.0);
		worldNorm = normal * mat3(worldT);
	#if TANGENT
		tang = tangent.xyz * mat3(worldT);
	#endif //_TANGENT
	}
	
#else //_VTF_TRANSFORM

#if ANIM
	vec4 worldPos = vec4(0.0, 0.0, 0.0, 1.0);
	vec3 worldNorm = vec3(0.0, 0.0, 0.0);
	#if TANGENT
	tang = vec3(0.0, 0.0, 0.0);
	#endif //_TANGENT

    for (int i = 0; i < int(numBones); i++)
    {
		int trOffset = int(blendIndices[i]) * 3;
		float weight = blendWeights[i];
		
		mat4 worldMatrix;
		worldMatrix[0] = worldMatrix3x4Array[trOffset];
		worldMatrix[1] = worldMatrix3x4Array[trOffset + 1];
		worldMatrix[2] = worldMatrix3x4Array[trOffset + 2];
		worldMatrix[3] = vec4(0.0, 0.0, 0.0, 1.0);
		
		worldPos.xyz += weight * (vertex * worldMatrix).xyz;
		
		mat3 worldRotMatrix = mat3(worldMatrix[0].xyz, worldMatrix[1].xyz, worldMatrix[2].xyz);
		worldNorm += weight * (normal * worldRotMatrix);
		tang += weight * (tangent.xyz * worldRotMatrix);
	}
	
	worldNorm = normalize(worldNorm);
	tang = normalize(tang);
	
#else //_ANIM

	vec4 worldPos = world * vertex;
	vec3 worldNorm = mat3(world) * normal;
	#if TANGENT
	tang = mat3(world) * tangent.xyz;
	#endif //_TANGENT
	
#endif //_ANIM

#endif //_VTF_TRANSFORM

	pos = view * worldPos;
	norm = mat3(view) * worldNorm;
	
#if TANGENT
	tang = mat3(view) * tang;
	binorm = cross(norm, tang)*tangent.w;
#endif

	uv.xy = uv0.xy;
	
	float difIdx = uv0.w;
	float asgIdx = floor(difIdx/65536 + 0.5);
	difIdx -= asgIdx*65536;
	float norIdx = floor(difIdx/256 + 0.5);
	difIdx -= norIdx*256;
	idx = vec3(difIdx, norIdx, asgIdx);
	
	gl_Position = viewproj * worldPos;
}
